
/* Copyright 1988-1991 UserLand Software, Inc.  All Rights Reserved.*/



#include "landinternal.h"



pascal boolean landpushparam (hdlverbrecord hverb, typaramtype type, Handle hval, void *pval, long len, typaramkeyword key) {
	
	/*
	2.1b3 dmb: no more typaramrecords
	*/
	
	register hdlverbrecord hv = hverb;
	AppleEvent event, reply;
	AERecord *evt;
	
	landsystem7geteventrecords (hv, &event, &reply);
	
	if ((**hv).verbtoken == returntoken)
		evt = &reply;
	else
		evt = &event;
	
	if (!landsystem7pushparam (evt, type, hval, pval, len, key))
		return (false);
	
	(**hv).ctparams++; /*added room for another param*/
	
	return (true);
	} /*landpushparam*/

	
pascal boolean landpushintparam (hdlverbrecord hverb, short x, typaramkeyword key) {
	
	return (landpushparam (hverb, inttype, nil, &x, longsizeof (x), key));
	} /*landpushintparam*/
	
	
pascal boolean landpushlongparam (hdlverbrecord hverb, long x, typaramkeyword key) {
	
	return (landpushparam (hverb, longtype, nil, &x, longsizeof (x), key));
	} /*landpushlongparam*/


pascal boolean landpushstringparam (hdlverbrecord hverb, bigstring bs, typaramkeyword key) {
	
	return (landpushparam (hverb, texttype, nil, bs + 1, stringlength (bs), key));
	} /*landpushstringparam*/




